import java.util.*;
import java.awt.AWTEvent;
import java.awt.event.MouseEvent;
import javax.media.j3d.*;
import com.sun.j3d.utils.picking.behaviors.*;
import com.sun.j3d.utils.picking.*;
import com.sun.j3d.utils.geometry.*;

/**
 * This class implements a simple pick behaviour.
 * It prints out a message identifying which object has been picked
 * by using the userData of the object.  The use of this class is
 * demonstrated in SimplePick.
 * @author I.J.Palmer
 * @version 1.0
 * @see SimplePick
 */
public class SimplePickRightBehaviour extends PickMouseBehavior {
	/** 
	 * The wake up criteria. 
	 * This is set to trigger on mouse events using the MOUSE_EVENT_MASK.
	 */
	WakeupOnAWTEvent buttonPressed = 
		new WakeupOnAWTEvent(MouseEvent.MOUSE_EVENT_MASK);

	/**
         * @param pickRoot BranchGroup that is the root of the picking operation.
	 * @param pickCanvas Canvas3D used in the pick operation.
	 * @param pickBounds Bounds that define the behaviour's active region.
         */
  	public SimplePickRightBehaviour(Canvas3D pickCanvas, 
			       BranchGroup pickRoot, Bounds pickBounds) {
      		super(pickCanvas, pickRoot, pickBounds);
      		setSchedulingBounds(pickBounds);
  	}

	/** Sets the wake up criterion to the mouse button criteria */
	public void initialize() {
		wakeupOn(buttonPressed);
	}

	/**
	 * Where the processing is carried out.
	 * This obtains the AWT mouse event, checks if it is the left mouse button
	 * and then uses the x and y coodinates of the mouse position to 
	 * pick an object.  A message is printed according to which object has been picked.
	 * Finally the wake up condition is set to the mouse 
	 * criterion again.
	 */
	public void processStimulus(Enumeration criteria) {
		WakeupOnAWTEvent theCriterion = (WakeupOnAWTEvent) criteria.nextElement();
		AWTEvent theEvents[] = theCriterion.getAWTEvent();
		if (theEvents[0].getID() == MouseEvent.MOUSE_RELEASED) {
		  MouseEvent theMouseEvent = (MouseEvent) theEvents[0];
		  if ((theMouseEvent.getModifiers() & MouseEvent.BUTTON1_MASK) != 0) {
			int xpos = theMouseEvent.getX();
			int ypos = theMouseEvent.getY();
			Primitive pickedShape = null;
                                                PickResult pickResult = null;
                                                pickCanvas.setShapeLocation(xpos,ypos);
                                                pickResult = pickCanvas.pickClosest();
                                                if (pickResult != null)
                                                    pickedShape = (Primitive) pickResult.getNode(PickResult.PRIMITIVE);
			if (pickedShape != null)
				System.out.println("Picked the " + pickedShape.getUserData());
			else
				System.out.println("Picked nothing");
		  }
		}
		wakeupOn(buttonPressed);
	}
	/** 
	 * This performs no processing but is required
	 * as the parent class is abstract.
         */
	public void updateScene(int xpos, int ypos) {}
}
